#include <sys/time.h>
#include <cstdlib>
#include <cstddef>
#include <iostream>

#include <immintrin.h>
#include <papi.h>

double etime()
{
  struct timeval tv;
  gettimeofday(&tv, NULL);
  return tv.tv_sec + (double)tv.tv_usec*1e-6;
}

#include "test_utils_sgl.hpp"

int main(int argc, char* argv[])
{
  if (argc < 2) {
    std::cerr << "Usage: " << argv[0] << " nloops" << std::endl;
    std::exit(EXIT_FAILURE);
  }
  int nloop = std::atoi( argv[1] );
  int retval;

  // initialize papi library
  retval = PAPI_library_init( PAPI_VER_CURRENT );
  if (retval != PAPI_VER_CURRENT) {
    std::cerr << "PAPI library init error!" << std::endl;
    std::exit(EXIT_FAILURE);
  }

  long long ops;
  double dt, gflops;
  double res = test_simd(nloop, ops, dt, gflops);

  std::cout << "number of operations: " << ops << std::endl;
  std::cout << "elapsed time: " << dt << std::endl;
  std::cout << "GFLOPS: " << gflops << std::endl;
}
