double test_simd(int nloop, long long& ops, double& dt, double& gflops) {

  long long values[1];

  __m256d a[16];
  for (int i = 0; i < 16; ++i) {
    a[i] = _mm256_set_pd(0.5, 2.2, 1.6, 3.1);
  }

  double t0 = etime();
  int EventSet = PAPI_NULL;
  PAPI_create_eventset( &EventSet );
  PAPI_add_event(EventSet, PAPI_VEC_DP);
  //PAPI_add_event(EventSet, PAPI_DP_OPS);
  PAPI_start( EventSet );
  for (int i = 0; i < nloop; ++i) {
    // 1
    a[ 0] = _mm256_mul_pd(a[ 0], a[ 0]);
    a[ 1] = _mm256_mul_pd(a[ 1], a[ 1]);
    a[ 2] = _mm256_mul_pd(a[ 2], a[ 2]);
    a[ 3] = _mm256_mul_pd(a[ 3], a[ 3]);
    a[ 4] = _mm256_mul_pd(a[ 4], a[ 4]);
    a[ 5] = _mm256_mul_pd(a[ 5], a[ 5]);
    a[ 6] = _mm256_mul_pd(a[ 6], a[ 6]);
    a[ 7] = _mm256_mul_pd(a[ 7], a[ 7]);
    a[ 8] = _mm256_mul_pd(a[ 8], a[ 8]);
    a[ 9] = _mm256_mul_pd(a[ 9], a[ 9]);
    a[10] = _mm256_mul_pd(a[10], a[10]);
    a[11] = _mm256_mul_pd(a[11], a[11]);
    a[12] = _mm256_mul_pd(a[12], a[12]);
    a[13] = _mm256_mul_pd(a[13], a[13]);
    a[14] = _mm256_mul_pd(a[14], a[14]);
    a[15] = _mm256_mul_pd(a[15], a[15]);
    a[ 0] = _mm256_add_pd(a[ 0], a[ 0]);
    a[ 1] = _mm256_add_pd(a[ 1], a[ 1]);
    a[ 2] = _mm256_add_pd(a[ 2], a[ 2]);
    a[ 3] = _mm256_add_pd(a[ 3], a[ 3]);
    a[ 4] = _mm256_add_pd(a[ 4], a[ 4]);
    a[ 5] = _mm256_add_pd(a[ 5], a[ 5]);
    a[ 6] = _mm256_add_pd(a[ 6], a[ 6]);
    a[ 7] = _mm256_add_pd(a[ 7], a[ 7]);
    a[ 8] = _mm256_add_pd(a[ 8], a[ 8]);
    a[ 9] = _mm256_add_pd(a[ 9], a[ 9]);
    a[10] = _mm256_add_pd(a[10], a[10]);
    a[11] = _mm256_add_pd(a[11], a[11]);
    a[12] = _mm256_add_pd(a[12], a[12]);
    a[13] = _mm256_add_pd(a[13], a[13]);
    a[14] = _mm256_add_pd(a[14], a[14]);
    a[15] = _mm256_add_pd(a[15], a[15]);

    // 2
    a[ 0] = _mm256_mul_pd(a[ 0], a[ 0]);
    a[ 1] = _mm256_mul_pd(a[ 1], a[ 1]);
    a[ 2] = _mm256_mul_pd(a[ 2], a[ 2]);
    a[ 3] = _mm256_mul_pd(a[ 3], a[ 3]);
    a[ 4] = _mm256_mul_pd(a[ 4], a[ 4]);
    a[ 5] = _mm256_mul_pd(a[ 5], a[ 5]);
    a[ 6] = _mm256_mul_pd(a[ 6], a[ 6]);
    a[ 7] = _mm256_mul_pd(a[ 7], a[ 7]);
    a[ 8] = _mm256_mul_pd(a[ 8], a[ 8]);
    a[ 9] = _mm256_mul_pd(a[ 9], a[ 9]);
    a[10] = _mm256_mul_pd(a[10], a[10]);
    a[11] = _mm256_mul_pd(a[11], a[11]);
    a[12] = _mm256_mul_pd(a[12], a[12]);
    a[13] = _mm256_mul_pd(a[13], a[13]);
    a[14] = _mm256_mul_pd(a[14], a[14]);
    a[15] = _mm256_mul_pd(a[15], a[15]);
    a[ 0] = _mm256_add_pd(a[ 0], a[ 0]);
    a[ 1] = _mm256_add_pd(a[ 1], a[ 1]);
    a[ 2] = _mm256_add_pd(a[ 2], a[ 2]);
    a[ 3] = _mm256_add_pd(a[ 3], a[ 3]);
    a[ 4] = _mm256_add_pd(a[ 4], a[ 4]);
    a[ 5] = _mm256_add_pd(a[ 5], a[ 5]);
    a[ 6] = _mm256_add_pd(a[ 6], a[ 6]);
    a[ 7] = _mm256_add_pd(a[ 7], a[ 7]);
    a[ 8] = _mm256_add_pd(a[ 8], a[ 8]);
    a[ 9] = _mm256_add_pd(a[ 9], a[ 9]);
    a[10] = _mm256_add_pd(a[10], a[10]);
    a[11] = _mm256_add_pd(a[11], a[11]);
    a[12] = _mm256_add_pd(a[12], a[12]);
    a[13] = _mm256_add_pd(a[13], a[13]);
    a[14] = _mm256_add_pd(a[14], a[14]);
    a[15] = _mm256_add_pd(a[15], a[15]);

    // 3
    a[ 0] = _mm256_mul_pd(a[ 0], a[ 0]);
    a[ 1] = _mm256_mul_pd(a[ 1], a[ 1]);
    a[ 2] = _mm256_mul_pd(a[ 2], a[ 2]);
    a[ 3] = _mm256_mul_pd(a[ 3], a[ 3]);
    a[ 4] = _mm256_mul_pd(a[ 4], a[ 4]);
    a[ 5] = _mm256_mul_pd(a[ 5], a[ 5]);
    a[ 6] = _mm256_mul_pd(a[ 6], a[ 6]);
    a[ 7] = _mm256_mul_pd(a[ 7], a[ 7]);
    a[ 8] = _mm256_mul_pd(a[ 8], a[ 8]);
    a[ 9] = _mm256_mul_pd(a[ 9], a[ 9]);
    a[10] = _mm256_mul_pd(a[10], a[10]);
    a[11] = _mm256_mul_pd(a[11], a[11]);
    a[12] = _mm256_mul_pd(a[12], a[12]);
    a[13] = _mm256_mul_pd(a[13], a[13]);
    a[14] = _mm256_mul_pd(a[14], a[14]);
    a[15] = _mm256_mul_pd(a[15], a[15]);
    a[ 0] = _mm256_add_pd(a[ 0], a[ 0]);
    a[ 1] = _mm256_add_pd(a[ 1], a[ 1]);
    a[ 2] = _mm256_add_pd(a[ 2], a[ 2]);
    a[ 3] = _mm256_add_pd(a[ 3], a[ 3]);
    a[ 4] = _mm256_add_pd(a[ 4], a[ 4]);
    a[ 5] = _mm256_add_pd(a[ 5], a[ 5]);
    a[ 6] = _mm256_add_pd(a[ 6], a[ 6]);
    a[ 7] = _mm256_add_pd(a[ 7], a[ 7]);
    a[ 8] = _mm256_add_pd(a[ 8], a[ 8]);
    a[ 9] = _mm256_add_pd(a[ 9], a[ 9]);
    a[10] = _mm256_add_pd(a[10], a[10]);
    a[11] = _mm256_add_pd(a[11], a[11]);
    a[12] = _mm256_add_pd(a[12], a[12]);
    a[13] = _mm256_add_pd(a[13], a[13]);
    a[14] = _mm256_add_pd(a[14], a[14]);
    a[15] = _mm256_add_pd(a[15], a[15]);

    // 4
    a[ 0] = _mm256_mul_pd(a[ 0], a[ 0]);
    a[ 1] = _mm256_mul_pd(a[ 1], a[ 1]);
    a[ 2] = _mm256_mul_pd(a[ 2], a[ 2]);
    a[ 3] = _mm256_mul_pd(a[ 3], a[ 3]);
    a[ 4] = _mm256_mul_pd(a[ 4], a[ 4]);
    a[ 5] = _mm256_mul_pd(a[ 5], a[ 5]);
    a[ 6] = _mm256_mul_pd(a[ 6], a[ 6]);
    a[ 7] = _mm256_mul_pd(a[ 7], a[ 7]);
    a[ 8] = _mm256_mul_pd(a[ 8], a[ 8]);
    a[ 9] = _mm256_mul_pd(a[ 9], a[ 9]);
    a[10] = _mm256_mul_pd(a[10], a[10]);
    a[11] = _mm256_mul_pd(a[11], a[11]);
    a[12] = _mm256_mul_pd(a[12], a[12]);
    a[13] = _mm256_mul_pd(a[13], a[13]);
    a[14] = _mm256_mul_pd(a[14], a[14]);
    a[15] = _mm256_mul_pd(a[15], a[15]);
    a[ 0] = _mm256_add_pd(a[ 0], a[ 0]);
    a[ 1] = _mm256_add_pd(a[ 1], a[ 1]);
    a[ 2] = _mm256_add_pd(a[ 2], a[ 2]);
    a[ 3] = _mm256_add_pd(a[ 3], a[ 3]);
    a[ 4] = _mm256_add_pd(a[ 4], a[ 4]);
    a[ 5] = _mm256_add_pd(a[ 5], a[ 5]);
    a[ 6] = _mm256_add_pd(a[ 6], a[ 6]);
    a[ 7] = _mm256_add_pd(a[ 7], a[ 7]);
    a[ 8] = _mm256_add_pd(a[ 8], a[ 8]);
    a[ 9] = _mm256_add_pd(a[ 9], a[ 9]);
    a[10] = _mm256_add_pd(a[10], a[10]);
    a[11] = _mm256_add_pd(a[11], a[11]);
    a[12] = _mm256_add_pd(a[12], a[12]);
    a[13] = _mm256_add_pd(a[13], a[13]);
    a[14] = _mm256_add_pd(a[14], a[14]);
    a[15] = _mm256_add_pd(a[15], a[15]);

    // 5
    a[ 0] = _mm256_mul_pd(a[ 0], a[ 0]);
    a[ 1] = _mm256_mul_pd(a[ 1], a[ 1]);
    a[ 2] = _mm256_mul_pd(a[ 2], a[ 2]);
    a[ 3] = _mm256_mul_pd(a[ 3], a[ 3]);
    a[ 4] = _mm256_mul_pd(a[ 4], a[ 4]);
    a[ 5] = _mm256_mul_pd(a[ 5], a[ 5]);
    a[ 6] = _mm256_mul_pd(a[ 6], a[ 6]);
    a[ 7] = _mm256_mul_pd(a[ 7], a[ 7]);
    a[ 8] = _mm256_mul_pd(a[ 8], a[ 8]);
    a[ 9] = _mm256_mul_pd(a[ 9], a[ 9]);
    a[10] = _mm256_mul_pd(a[10], a[10]);
    a[11] = _mm256_mul_pd(a[11], a[11]);
    a[12] = _mm256_mul_pd(a[12], a[12]);
    a[13] = _mm256_mul_pd(a[13], a[13]);
    a[14] = _mm256_mul_pd(a[14], a[14]);
    a[15] = _mm256_mul_pd(a[15], a[15]);
    a[ 0] = _mm256_add_pd(a[ 0], a[ 0]);
    a[ 1] = _mm256_add_pd(a[ 1], a[ 1]);
    a[ 2] = _mm256_add_pd(a[ 2], a[ 2]);
    a[ 3] = _mm256_add_pd(a[ 3], a[ 3]);
    a[ 4] = _mm256_add_pd(a[ 4], a[ 4]);
    a[ 5] = _mm256_add_pd(a[ 5], a[ 5]);
    a[ 6] = _mm256_add_pd(a[ 6], a[ 6]);
    a[ 7] = _mm256_add_pd(a[ 7], a[ 7]);
    a[ 8] = _mm256_add_pd(a[ 8], a[ 8]);
    a[ 9] = _mm256_add_pd(a[ 9], a[ 9]);
    a[10] = _mm256_add_pd(a[10], a[10]);
    a[11] = _mm256_add_pd(a[11], a[11]);
    a[12] = _mm256_add_pd(a[12], a[12]);
    a[13] = _mm256_add_pd(a[13], a[13]);
    a[14] = _mm256_add_pd(a[14], a[14]);
    a[15] = _mm256_add_pd(a[15], a[15]);

    // 6
    a[ 0] = _mm256_mul_pd(a[ 0], a[ 0]);
    a[ 1] = _mm256_mul_pd(a[ 1], a[ 1]);
    a[ 2] = _mm256_mul_pd(a[ 2], a[ 2]);
    a[ 3] = _mm256_mul_pd(a[ 3], a[ 3]);
    a[ 4] = _mm256_mul_pd(a[ 4], a[ 4]);
    a[ 5] = _mm256_mul_pd(a[ 5], a[ 5]);
    a[ 6] = _mm256_mul_pd(a[ 6], a[ 6]);
    a[ 7] = _mm256_mul_pd(a[ 7], a[ 7]);
    a[ 8] = _mm256_mul_pd(a[ 8], a[ 8]);
    a[ 9] = _mm256_mul_pd(a[ 9], a[ 9]);
    a[10] = _mm256_mul_pd(a[10], a[10]);
    a[11] = _mm256_mul_pd(a[11], a[11]);
    a[12] = _mm256_mul_pd(a[12], a[12]);
    a[13] = _mm256_mul_pd(a[13], a[13]);
    a[14] = _mm256_mul_pd(a[14], a[14]);
    a[15] = _mm256_mul_pd(a[15], a[15]);
    a[ 0] = _mm256_add_pd(a[ 0], a[ 0]);
    a[ 1] = _mm256_add_pd(a[ 1], a[ 1]);
    a[ 2] = _mm256_add_pd(a[ 2], a[ 2]);
    a[ 3] = _mm256_add_pd(a[ 3], a[ 3]);
    a[ 4] = _mm256_add_pd(a[ 4], a[ 4]);
    a[ 5] = _mm256_add_pd(a[ 5], a[ 5]);
    a[ 6] = _mm256_add_pd(a[ 6], a[ 6]);
    a[ 7] = _mm256_add_pd(a[ 7], a[ 7]);
    a[ 8] = _mm256_add_pd(a[ 8], a[ 8]);
    a[ 9] = _mm256_add_pd(a[ 9], a[ 9]);
    a[10] = _mm256_add_pd(a[10], a[10]);
    a[11] = _mm256_add_pd(a[11], a[11]);
    a[12] = _mm256_add_pd(a[12], a[12]);
    a[13] = _mm256_add_pd(a[13], a[13]);
    a[14] = _mm256_add_pd(a[14], a[14]);
    a[15] = _mm256_add_pd(a[15], a[15]);

    // 7
    a[ 0] = _mm256_mul_pd(a[ 0], a[ 0]);
    a[ 1] = _mm256_mul_pd(a[ 1], a[ 1]);
    a[ 2] = _mm256_mul_pd(a[ 2], a[ 2]);
    a[ 3] = _mm256_mul_pd(a[ 3], a[ 3]);
    a[ 4] = _mm256_mul_pd(a[ 4], a[ 4]);
    a[ 5] = _mm256_mul_pd(a[ 5], a[ 5]);
    a[ 6] = _mm256_mul_pd(a[ 6], a[ 6]);
    a[ 7] = _mm256_mul_pd(a[ 7], a[ 7]);
    a[ 8] = _mm256_mul_pd(a[ 8], a[ 8]);
    a[ 9] = _mm256_mul_pd(a[ 9], a[ 9]);
    a[10] = _mm256_mul_pd(a[10], a[10]);
    a[11] = _mm256_mul_pd(a[11], a[11]);
    a[12] = _mm256_mul_pd(a[12], a[12]);
    a[13] = _mm256_mul_pd(a[13], a[13]);
    a[14] = _mm256_mul_pd(a[14], a[14]);
    a[15] = _mm256_mul_pd(a[15], a[15]);
    a[ 0] = _mm256_add_pd(a[ 0], a[ 0]);
    a[ 1] = _mm256_add_pd(a[ 1], a[ 1]);
    a[ 2] = _mm256_add_pd(a[ 2], a[ 2]);
    a[ 3] = _mm256_add_pd(a[ 3], a[ 3]);
    a[ 4] = _mm256_add_pd(a[ 4], a[ 4]);
    a[ 5] = _mm256_add_pd(a[ 5], a[ 5]);
    a[ 6] = _mm256_add_pd(a[ 6], a[ 6]);
    a[ 7] = _mm256_add_pd(a[ 7], a[ 7]);
    a[ 8] = _mm256_add_pd(a[ 8], a[ 8]);
    a[ 9] = _mm256_add_pd(a[ 9], a[ 9]);
    a[10] = _mm256_add_pd(a[10], a[10]);
    a[11] = _mm256_add_pd(a[11], a[11]);
    a[12] = _mm256_add_pd(a[12], a[12]);
    a[13] = _mm256_add_pd(a[13], a[13]);
    a[14] = _mm256_add_pd(a[14], a[14]);
    a[15] = _mm256_add_pd(a[15], a[15]);

    // 8
    a[ 0] = _mm256_mul_pd(a[ 0], a[ 0]);
    a[ 1] = _mm256_mul_pd(a[ 1], a[ 1]);
    a[ 2] = _mm256_mul_pd(a[ 2], a[ 2]);
    a[ 3] = _mm256_mul_pd(a[ 3], a[ 3]);
    a[ 4] = _mm256_mul_pd(a[ 4], a[ 4]);
    a[ 5] = _mm256_mul_pd(a[ 5], a[ 5]);
    a[ 6] = _mm256_mul_pd(a[ 6], a[ 6]);
    a[ 7] = _mm256_mul_pd(a[ 7], a[ 7]);
    a[ 8] = _mm256_mul_pd(a[ 8], a[ 8]);
    a[ 9] = _mm256_mul_pd(a[ 9], a[ 9]);
    a[10] = _mm256_mul_pd(a[10], a[10]);
    a[11] = _mm256_mul_pd(a[11], a[11]);
    a[12] = _mm256_mul_pd(a[12], a[12]);
    a[13] = _mm256_mul_pd(a[13], a[13]);
    a[14] = _mm256_mul_pd(a[14], a[14]);
    a[15] = _mm256_mul_pd(a[15], a[15]);
    a[ 0] = _mm256_add_pd(a[ 0], a[ 0]);
    a[ 1] = _mm256_add_pd(a[ 1], a[ 1]);
    a[ 2] = _mm256_add_pd(a[ 2], a[ 2]);
    a[ 3] = _mm256_add_pd(a[ 3], a[ 3]);
    a[ 4] = _mm256_add_pd(a[ 4], a[ 4]);
    a[ 5] = _mm256_add_pd(a[ 5], a[ 5]);
    a[ 6] = _mm256_add_pd(a[ 6], a[ 6]);
    a[ 7] = _mm256_add_pd(a[ 7], a[ 7]);
    a[ 8] = _mm256_add_pd(a[ 8], a[ 8]);
    a[ 9] = _mm256_add_pd(a[ 9], a[ 9]);
    a[10] = _mm256_add_pd(a[10], a[10]);
    a[11] = _mm256_add_pd(a[11], a[11]);
    a[12] = _mm256_add_pd(a[12], a[12]);
    a[13] = _mm256_add_pd(a[13], a[13]);
    a[14] = _mm256_add_pd(a[14], a[14]);
    a[15] = _mm256_add_pd(a[15], a[15]);

  }
  PAPI_stop( EventSet, values);
  double t1 = etime();
  dt = t1 - t0;

  ops =values[0];
  gflops = 2.0*ops/dt*1.0e-9;
  //gflops = 1.0*ops/dt*1.0e-9;

  __m256d res = _mm256_setzero_pd();
  for (int i = 0; i < 8; ++i) {
    res = _mm256_add_pd(res, a[i]);
  }

  double *val;
  if (posix_memalign((void **) &(val), 32, sizeof(double)*2) != 0) {
    std::cerr << "memory allocation error." << std::endl;
    std::exit(EXIT_FAILURE);
  }
  _mm256_store_pd(val, res);

  return val[0] + val[1];
}
